/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bedwars.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.MineHome.Bedwars.Spectator.Spectator;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Bedwars - Is Spectating")
@Description(value={"Checks if a player is spectating a Bedwars game."})
@Examples(value={"if loop-player is spectating Bedwars:"})
public class CondSpectating
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 2 || matchedPattern == 3);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is spectating Bedwars";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return Spectator.is((Player)((Player)this.player.getSingle(e))) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondSpectating.class, (String[])new String[]{"%player% is spectating [Bedwars]", "%player% is [a] [Bedwars] spectator", "%player% is(n't| not) spectating [Bedwars]", "%player% is(n't| not) [a] [Bedwars] spectator"});
    }
}

