/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.autorank.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.autorank.AutorankHook;

@Name(value="Autorank - Current Path")
@Description(value={"Returns the current path of a player."})
@Examples(value={"send \"Your current path: %current path of player%\""})
public class ExprCurrentPath
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "current path of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new String[]{AutorankHook.autorankAPI.getActivePath(((Player)this.player.getSingle(e)).getUniqueId()).getDisplayName()};
    }

    static {
        Skript.registerExpression(ExprCurrentPath.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [(current|active)] [Autorank] path of %player%", "%player%'s [(current|active)] [Autorank] path"});
    }
}

