/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.advancedsurvivalgames.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import e.SGPlayer;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.advancedsurvivalgames.AdvancedSurvivalGamesHook;

@Name(value="AdvancedSurvivalGames - Bounty")
@Description(value={"Returns the bounty of a player."})
@Examples(value={"send \"Your bounty: %survival games bounty of player%\""})
public class ExprBounty
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the survival games bounty of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{AdvancedSurvivalGamesHook.playerManager.getSGPlayer((OfflinePlayer)this.player.getSingle(e)).getBounty()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.player.getSingle(e) == null) {
            return;
        }
        int bountyChange = ((Number)delta[0]).intValue();
        SGPlayer sgPlayer = AdvancedSurvivalGamesHook.playerManager.getSGPlayer((OfflinePlayer)this.player.getSingle(e));
        if (mode == Changer.ChangeMode.SET) {
            sgPlayer.setBounty(bountyChange);
        } else if (mode == Changer.ChangeMode.ADD) {
            sgPlayer.setBounty(sgPlayer.getBounty() + bountyChange);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            sgPlayer.setBounty(sgPlayer.getBounty() - bountyChange);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprBounty.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [[advanced] (survival games|sg)] bounty of %offlineplayer%", "%offlineplayer%'s [[advanced] (survival games|sg)] bounty"});
    }
}

