/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.skywars_cookloco.conditions;

import ak.CookLoco.SkyWars.api.SkyWarsAPI;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="SkyWars (CookLoco) - Is Spectating")
@Description(value={"Checks if a player is spectating."})
@Examples(value={"if player is spectating a skywars game:"})
public class CondSpectating
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 2 || matchedPattern == 3);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is spectating a SkyWars game";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return SkyWarsAPI.getSkyPlayer((Player)((Player)this.player.getSingle(e))).isSpectating();
    }

    static {
        Skript.registerCondition(CondSpectating.class, (String[])new String[]{"%player% is [currently] spectating [a] SkyWars [game]", "%player% is [currently] [a] [SkyWars] spectator", "%player% is(n't| not) [currently] spectating [a] SkyWars [game]", "%player% is(n't| not) [currently] [a] [SkyWars] spectator"});
    }
}

