/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import com.nisovin.shopkeepers.api.shopkeeper.player.PlayerShopkeeper;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Shopkeepers of Player")
@Description(value={"Returns the IDs of the shopkeepers of a player."})
@Examples(value={"send \"%the shopkeepers of player\""})
public class ExprKeepersOfPlayer
extends SimpleExpression<Integer> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "shopkeepers of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Integer[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (Integer[])ShopkeepersHook.shopkeeperRegistry.getAllShopkeepers().stream().filter(keeper -> keeper instanceof PlayerShopkeeper && ((PlayerShopkeeper)keeper).getOwnerUUID().equals(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())).map(Shopkeeper::getId).toArray(Integer[]::new);
    }

    static {
        Skript.registerExpression(ExprKeepersOfPlayer.class, Integer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [IDs of all [the]] [shop]keepers of %offlineplayer%", "[(all [[of] the]|the)] [IDs of [all]] %offlineplayer%'s [shop]keepers"});
    }
}

