/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import us._donut_.skuniversal.shopkeepers.ShopkeepersHook;

@Name(value="Shopkeepers - Is Shopkeeper")
@Description(value={"Checks if an entity is a shopkeeper."})
@Examples(value={"if event-entity is a shopkeeper:"})
public class CondIsKeeper
extends Condition {
    private Expression<Entity> entity;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.entity = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "entity " + this.entity.toString(e, b) + " is a shopkeeper";
    }

    public boolean check(Event e) {
        if (this.entity.getSingle(e) == null) {
            return this.isNegated();
        }
        return ShopkeepersHook.shopkeeperRegistry.isShopkeeper((Entity)this.entity.getSingle(e)) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondIsKeeper.class, (String[])new String[]{"%entity% is [a] [shop]keeper", "%entity% is(n't| not) [a] [shop]keeper"});
    }
}

