/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.pvplevels.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.pvplevels.PvPLevelsHook;
import us._donut_.skuniversal.pvplevels.expressions.ExprXp;

@Name(value="PvPLevels - Required XP")
@Description(value={"Returns the XP needed for a player to level up."})
@Examples(value={"send \"%pvp xp required for player to level up%\""})
public class ExprXpRequired
extends SimpleExpression<Number> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "xp required to for player " + this.player.toString(e, b) + " to level up";
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{PvPLevelsHook.pvpLevelsAPI.CurrentXPRequired((Player)this.player.getSingle(e))};
    }

    static {
        Skript.registerExpression(ExprXp.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] PvP[Levels] (xp|exp[erience]) of %offlineplayer%", "%offlineplayer%'s PvP[Levels] (xp|exp[erience])"});
    }
}

