/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.pvplevels.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.pvplevels.PvPLevelsHook;

@Name(value="PvPLevels - Deaths of Player")
@Description(value={"Returns the number of deaths of a player."})
@Examples(value={"send \"%pvp deaths of player%\""})
public class ExprDeaths
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "number of deaths of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{PvPLevelsHook.pvpLevelsAPI.CurrentDeathsOfflinePlayer((OfflinePlayer)this.player.getSingle(e))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.player.getSingle(e) == null) {
            return;
        }
        int deathsChange = ((Number)delta[0]).intValue();
        if (mode == Changer.ChangeMode.SET) {
            PvPLevelsHook.pvpLevelsAPI.SetDeaths(((OfflinePlayer)this.player.getSingle(e)).getPlayer(), Integer.valueOf(deathsChange));
        } else if (mode == Changer.ChangeMode.ADD) {
            PvPLevelsHook.pvpLevelsAPI.AddDeaths(((OfflinePlayer)this.player.getSingle(e)).getPlayer(), Integer.valueOf(deathsChange));
        } else if (mode == Changer.ChangeMode.REMOVE) {
            PvPLevelsHook.pvpLevelsAPI.RemoveDeaths(((OfflinePlayer)this.player.getSingle(e)).getPlayer(), Integer.valueOf(deathsChange));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprDeaths.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [(number|amount) of] PvP[Levels] deaths of %offlineplayer%", "%offlineplayer%'s [(number|amount) of] PvP[Levels] deaths"});
    }
}

