/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Percent Left")
@Description(value={"Returns the percentage of blocks left in a mine."})
@Examples(value={"send \"%the percentage of the blocks not mined in the mine at player%\""})
public class ExprPercentLeft
extends SimpleExpression<Number> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "percentage of blocks left in mine named " + this.name.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return null;
        }
        return new Number[]{PrisonMinesHook.mineAPI.getPercentLeft(mine)};
    }

    static {
        Skript.registerExpression(ExprPercentLeft.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] percent[age] of [the] blocks (left|not mined) in [the] [PrisonMines] mine [(named|with name)] %string%"});
    }
}

