/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Mine at Location")
@Description(value={"Returns the name of a mine at a location."})
@Examples(value={"send \"%the mine at player%\""})
public class ExprMineAtLoc
extends SimpleExpression<String> {
    private Expression<Location> loc;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.loc = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "name of mine at location " + this.loc.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Mine mine;
        if (this.loc.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByLocation((Location)this.loc.getSingle(e))) == null) {
            return null;
        }
        return new String[]{mine.getName()};
    }

    static {
        Skript.registerExpression(ExprMineAtLoc.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [name of [the]] [PrisonMines] mine at %location%"});
    }
}

