/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Has Teleport Location")
@Description(value={"Checks if a mine has a teleport location."})
@Examples(value={"if the mine with name \"cool\" has a teleport location:"})
public class CondTeleportLoc
extends Condition {
    private Expression<String> name;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "mine named " + this.name.toString(e, b) + " has teleport location";
    }

    public boolean check(Event e) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return this.isNegated();
        }
        return mine.hasTeleportLocation() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondTeleportLoc.class, (String[])new String[]{"[the] [PrisonMines] mine [(named|with name)] %string% has [a] (teleport|tp) loc[ation]", "[the] [PrisonMines] mine [(named|with name)] %string% does(n't| not) have [a] (teleport|tp) loc[ation]"});
    }
}

