/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.prisonmines.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.lightshard.prisonmines.mine.Mine;
import org.bukkit.event.Event;
import us._donut_.skuniversal.prisonmines.PrisonMinesHook;

@Name(value="PrisonMines - Is Resetting")
@Description(value={"Checks if a mine is currently resetting."})
@Examples(value={"if the mine with name \"cool\" is resetting:"})
public class CondResetting
extends Condition {
    private Expression<String> name;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "mine named " + this.name.toString(e, b) + " is resetting";
    }

    public boolean check(Event e) {
        Mine mine;
        if (this.name.getSingle(e) == null || (mine = PrisonMinesHook.mineAPI.getByName((String)this.name.getSingle(e))) == null) {
            return this.isNegated();
        }
        return mine.isResetting() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondResetting.class, (String[])new String[]{"[the] [PrisonMines] mine [(named|with name)] %string% is (resetting|being reset)", "[the] [PrisonMines] mine [(named|with name)] %string% is(n't| not) (resetting|being reset)"});
    }
}

