/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.intellectualcrafters.plot.object.Plot;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredHook;

@Name(value="PlotSquared - Plot Border Blocks")
@Description(value={"Returns the border blocks of a plot."})
@Examples(value={"set the border blocks at height 65 of the plot with id (id of plot at player) to dirt"})
public class ExprBorderBlocks
extends SimpleExpression<Block> {
    private Expression<String> id;
    private Expression<Number> borderHeight;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.borderHeight = e[0];
        this.id = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "border blocks of plot of with id " + this.id.toString(e, b);
    }

    private com.intellectualcrafters.plot.object.Location getNECorner(com.intellectualcrafters.plot.object.Location ... corners) {
        block0: for (com.intellectualcrafters.plot.object.Location corner : corners) {
            for (com.intellectualcrafters.plot.object.Location otherCorner : corners) {
                if (corner.getX() < otherCorner.getX() || corner.getZ() > otherCorner.getZ()) continue block0;
            }
            return corner;
        }
        return null;
    }

    private com.intellectualcrafters.plot.object.Location getNWCorner(com.intellectualcrafters.plot.object.Location ... corners) {
        block0: for (com.intellectualcrafters.plot.object.Location corner : corners) {
            for (com.intellectualcrafters.plot.object.Location otherCorner : corners) {
                if (corner.getX() > otherCorner.getX() || corner.getZ() > otherCorner.getZ()) continue block0;
            }
            return corner;
        }
        return null;
    }

    private com.intellectualcrafters.plot.object.Location getSECorner(com.intellectualcrafters.plot.object.Location ... corners) {
        block0: for (com.intellectualcrafters.plot.object.Location corner : corners) {
            for (com.intellectualcrafters.plot.object.Location otherCorner : corners) {
                if (corner.getX() < otherCorner.getX() || corner.getZ() < otherCorner.getZ()) continue block0;
            }
            return corner;
        }
        return null;
    }

    private com.intellectualcrafters.plot.object.Location getSWCorner(com.intellectualcrafters.plot.object.Location ... corners) {
        block0: for (com.intellectualcrafters.plot.object.Location corner : corners) {
            for (com.intellectualcrafters.plot.object.Location otherCorner : corners) {
                if (corner.getX() > otherCorner.getX() || corner.getZ() < otherCorner.getZ()) continue block0;
            }
            return corner;
        }
        return null;
    }

    @Nullable
    protected Block[] get(Event e) {
        Plot plot;
        if (this.id.getSingle(e) == null || this.borderHeight.getSingle(e) == null || (plot = PlotSquaredHook.getPlot((String)this.id.getSingle(e))) == null) {
            return null;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        com.intellectualcrafters.plot.object.Location[] corners = plot.getAllCorners().toArray(new com.intellectualcrafters.plot.object.Location[0]);
        com.intellectualcrafters.plot.object.Location northEastCorner = this.getNECorner(corners);
        com.intellectualcrafters.plot.object.Location northWestCorner = this.getNWCorner(corners);
        com.intellectualcrafters.plot.object.Location southEastCorner = this.getSECorner(corners);
        com.intellectualcrafters.plot.object.Location southWestCorner = this.getSWCorner(corners);
        if (plot.getAllCorners().size() == 4 && northEastCorner != null && northWestCorner != null && southEastCorner != null && southWestCorner != null) {
            double z;
            double x;
            northEastCorner.add(1, ((Number)this.borderHeight.getSingle(e)).intValue(), -1);
            northWestCorner.add(-1, ((Number)this.borderHeight.getSingle(e)).intValue(), -1);
            southEastCorner.add(1, ((Number)this.borderHeight.getSingle(e)).intValue(), 1);
            southWestCorner.add(-1, ((Number)this.borderHeight.getSingle(e)).intValue(), 1);
            for (x = (double)northWestCorner.getX(); x < (double)(northEastCorner.getX() + 1); x += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northWestCorner.getWorld()), x, (double)((Number)this.borderHeight.getSingle(e)).intValue(), (double)northWestCorner.getZ()).getBlock());
            }
            for (z = (double)northEastCorner.getZ(); z < (double)(southEastCorner.getZ() + 1); z += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northEastCorner.getWorld()), (double)northEastCorner.getX(), (double)((Number)this.borderHeight.getSingle(e)).intValue(), z).getBlock());
            }
            for (z = (double)northWestCorner.getZ(); z < (double)(southWestCorner.getZ() + 1); z += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northWestCorner.getWorld()), (double)northWestCorner.getX(), (double)((Number)this.borderHeight.getSingle(e)).intValue(), z).getBlock());
            }
            for (x = (double)southWestCorner.getX(); x < (double)(southEastCorner.getX() + 1); x += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)southWestCorner.getWorld()), x, (double)((Number)this.borderHeight.getSingle(e)).intValue(), (double)southWestCorner.getZ()).getBlock());
            }
            return blocks.toArray(new Block[0]);
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprBorderBlocks.class, Block.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] border blocks at (height|y[-value]) %number% of [the] [PlotSquared] plot [with ID] %string%"});
    }
}

