/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Party Online Members")
@Description(value={"Returns the online members of a party."})
@Examples(value={"send \"%the online members of the party named \"cool\"%\""})
public class ExprOnlineMembers
extends SimpleExpression<Player> {
    private Expression<String> name;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "online members of party named " + this.name.toString(e, b);
    }

    @Nullable
    protected Player[] get(Event e) {
        if (this.name.getSingle(e) == null) {
            return null;
        }
        return PartiesHook.partiesAPI.getPartyOnlinePlayers((String)this.name.getSingle(e)).toArray(new Player[0]);
    }

    static {
        Skript.registerExpression(ExprOnlineMembers.class, Player.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] online members of [the] party [(named|with name)] %string%", "[(all [[of] the]|the)] party [(named|with name)] %string%'s online members"});
    }
}

