/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Party Home")
@Description(value={"Returns the home location of a party."})
@Examples(value={"send \"%the home of the party named \"cool\"%\""})
public class ExprHome
extends SimpleExpression<Location> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "home location of party named " + this.name.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        if (this.name.getSingle(e) == null) {
            return null;
        }
        return new Location[]{PartiesHook.partiesAPI.getPartyHome((String)this.name.getSingle(e))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Location newLoc = (Location)delta[0];
        if (this.name.getSingle(e) == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            PartiesHook.partyHandler.loadParty((String)this.name.getSingle(e)).setHome(newLoc);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{Location.class}) : null;
    }

    static {
        Skript.registerExpression(ExprHome.class, Location.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] home [loc[ation]] of [the] party [(named|with name)] %string%", "[the] party [(named|with name)] %string%'s home [loc[ation]]"});
    }
}

