/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.parties.PartiesHook;

@Name(value="Parties - Is Player in Party")
@Description(value={"Checks if a player is in a party."})
@Examples(value={"if player is in a party:"})
public class CondInParty
extends Condition {
    private Expression<OfflinePlayer> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is in a party";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return PartiesHook.partiesAPI.haveParty(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondInParty.class, (String[])new String[]{"%offlineplayer% is in [a] party", "%offlineplayer% is(n't| not) in [a] party"});
    }
}

