/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lwc.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.lwc.LWCHook;

@Name(value="LWC - Prtection Number")
@Description(value={"Returns the number of protections a player has."})
@Examples(value={"send \"%the number of protections of player%\""})
public class ExprProtectionNumber
extends SimpleExpression<Number> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "number of protections of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{LWCHook.lwc.getPhysicalDatabase().getProtectionCount(((Player)this.player.getSingle(e)).getName())};
    }

    static {
        Skript.registerExpression(ExprProtectionNumber.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [(number|amount) of] [LWC] protections of %player%", "%player%'s [(number|amount) of] [LWC] protections"});
    }
}

