/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lwc.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.lwc.LWCHook;

@Name(value="LWC - Player Access")
@Description(value={"Checks if a player has access to a block."})
@Examples(value={"if player has access to the clicked block:"})
public class CondAccess
extends Condition {
    private Expression<Player> player;
    private Expression<Block> block;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.block = e[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " has access to block " + this.block.toString(e, b);
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null || this.block.getSingle(e) == null) {
            return this.isNegated();
        }
        return LWCHook.lwc.canAccessProtection((Player)this.player.getSingle(e), (Block)this.block.getSingle(e)) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondAccess.class, (String[])new String[]{"%player% (has access to|can access) [LWC] [(locked|protected)] %block%", "%player% (does(n't| not) have access to|can('t|not) access) [LWC] [(locked|protected)] %block%"});
    }
}

