/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.luckperms.LuckPermsHook;

@Name(value="LuckPerms - Group of Player")
@Description(value={"Returns the group of a player."})
@Examples(value={"send \"%the luckperms group of player%\""})
public class ExprGroupOfPlayer
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "luckperms group of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        String[] stringArray;
        if (this.player.getSingle(e) == null) {
            return null;
        }
        User user = LuckPermsHook.luckpermsAPI.getUser(((Player)this.player.getSingle(e)).getUniqueId());
        if (user == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = user.getPrimaryGroup();
        }
        return stringArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.player.getSingle(e) == null) {
                return;
            }
            User user = LuckPermsHook.luckpermsAPI.getUser(((Player)this.player.getSingle(e)).getUniqueId());
            if (user == null) {
                return;
            }
            user.setPrimaryGroup((String)delta[0]);
            LuckPermsHook.luckpermsAPI.getUserManager().saveUser(user);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? (Class[])CollectionUtils.array((Object[])new Class[]{String.class}) : null;
    }

    static {
        Skript.registerExpression(ExprGroupOfPlayer.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [LuckPerm[s]] [primary] group of %player%", "%player%'s [primary] [LuckPerm[s]] group"});
    }
}

