/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.luckperms.LuckPermsHook;

@Name(value="LuckPerms - Remove Suffix")
@Description(value={"Removes suffix from player."})
@Examples(value={"remove \"[Owner]\" with priority 100 from the suffixes of player"})
public class EffRemoveSuffix
extends Effect {
    private Expression<String> suffix;
    private Expression<Number> priority;
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult p) {
        this.suffix = e[0];
        this.priority = e[1];
        this.player = e[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "remove suffix " + this.suffix.toString(e, b) + " with priority " + this.priority.toString(e, b) + " from player " + this.player.toString(e, b);
    }

    protected void execute(Event e) {
        if (this.suffix.getSingle(e) == null || this.priority.getSingle(e) == null || this.player.getSingle(e) == null) {
            return;
        }
        User user = LuckPermsHook.luckpermsAPI.getUser(((Player)this.player.getSingle(e)).getUniqueId());
        if (user == null) {
            return;
        }
        user.unsetPermission(LuckPermsHook.luckpermsAPI.getNodeFactory().makeSuffixNode(((Number)this.priority.getSingle(e)).intValue(), (String)this.suffix.getSingle(e)).build());
        LuckPermsHook.luckpermsAPI.getUserManager().saveUser(user);
    }

    static {
        Skript.registerEffect(EffRemoveSuffix.class, (String[])new String[]{"remove %string% with [a] priority [of] %number% from [the] [LuckPerm[s]] suffixes of %player%"});
    }
}

