/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.lockettepro.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.crafter.mc.lockettepro.LocketteProAPI;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="LockettePro - Is Block Locked")
@Description(value={"Checks if a block is locked."})
@Examples(value={"if the clicked block is locked:"})
public class CondLockedByLockettePro
extends Condition {
    private Expression<Block> block;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.block = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "block " + this.block.toString(e, b) + " is locked";
    }

    public boolean check(Event e) {
        if (this.block.getSingle(e) == null) {
            return this.isNegated();
        }
        return LocketteProAPI.isLocked((Block)((Block)this.block.getSingle(e))) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondLockedByLockettePro.class, (String[])new String[]{"%block% is (locked|protected) [by LockettePro]", "%block% is(n't| not) (locked|protected) [by LockettePro]"});
    }
}

