/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Claim Owner")
@Description(value={"Returns the owner of a claim."})
@Examples(value={"send \"%the owner of the claim with id (id of the basic claim at player)%\""})
public class ExprOwnerOfClaim
extends SimpleExpression<OfflinePlayer> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "owner of claim with id " + this.id.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        OfflinePlayer[] offlinePlayerArray;
        Claim claim = GriefPreventionHook.getClaim(((Number)this.id.getSingle(e)).longValue());
        if (claim == null) {
            offlinePlayerArray = null;
        } else {
            OfflinePlayer[] offlinePlayerArray2 = new OfflinePlayer[1];
            offlinePlayerArray = offlinePlayerArray2;
            offlinePlayerArray2[0] = Bukkit.getOfflinePlayer((String)claim.getOwnerName());
        }
        return offlinePlayerArray;
    }

    static {
        Skript.registerExpression(ExprOwnerOfClaim.class, OfflinePlayer.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] owner of [the] [G[rief]P[revention]] claim [with ID] %number%"});
    }
}

