/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.World;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Claim World")
@Description(value={"Returns the world of a claim."})
@Examples(value={"send \"%the world of the claim with id (id of the basic claim at player)%\""})
public class ExprClaimWorld
extends SimpleExpression<World> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends World> getReturnType() {
        return World.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "world of claim with id " + this.id.toString(e, b);
    }

    @Nullable
    protected World[] get(Event e) {
        World[] worldArray;
        Claim claim = GriefPreventionHook.getClaim(((Number)this.id.getSingle(e)).longValue());
        if (claim == null) {
            worldArray = null;
        } else {
            World[] worldArray2 = new World[1];
            worldArray = worldArray2;
            worldArray2[0] = claim.getLesserBoundaryCorner().getWorld();
        }
        return worldArray;
    }

    static {
        Skript.registerExpression(ExprClaimWorld.class, World.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] world of [the] [G[rief]P[revention]] claim [with ID] %number%"});
    }
}

