/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionHook;

@Name(value="GriefPrevention - Accrued Claim Blocks")
@Description(value={"Returns the accrued claim blocks of a player."})
@Examples(value={"send \"%the accrued claim blocks of player%\""})
public class ExprAccruedClaimBlocks
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "accrued claim blocks of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return new Number[]{GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).getAccruedClaimBlocks()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        int blockChange = ((Number)delta[0]).intValue();
        if (this.player.getSingle(e) == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).setAccruedClaimBlocks(Integer.valueOf(blockChange));
        } else if (mode == Changer.ChangeMode.ADD) {
            GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).setAccruedClaimBlocks(Integer.valueOf(GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).getAccruedClaimBlocks() + blockChange));
        } else if (mode == Changer.ChangeMode.REMOVE) {
            GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).setAccruedClaimBlocks(Integer.valueOf(GriefPreventionHook.dataStore.getPlayerData(((OfflinePlayer)this.player.getSingle(e)).getUniqueId()).getAccruedClaimBlocks() - blockChange));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprAccruedClaimBlocks.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [G[rief]P[revention]] accrued [claim] blocks of %offlineplayer%", "%offlineplayer%'s [G[rief]P[revention]] accrued [claim] blocks"});
    }
}

