/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.combatlog.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.combatlog.CombatLogHook;

@Name(value="CombatLog - Is Tagged")
@Description(value={"Checks if a player is combat tagged."})
@Examples(value={"if %player% is tagged:"})
public class CondTagged
extends Condition {
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "player " + this.player.toString(e, b) + " is tagged";
    }

    public boolean check(Event e) {
        if (this.player.getSingle(e) == null) {
            return this.isNegated();
        }
        return CombatLogHook.combatLog.taggedPlayers.containsKey(((Player)this.player.getSingle(e)).getName()) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondTagged.class, (String[])new String[]{"%player% is [currently] [CombatLog] tagged", "%player% is(n't| not) [currently] [CombatLog] tagged"});
    }
}

