/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.clearlagg.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.minebuilders.clearlag.events.EntityRemoveEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="ClearLagg - Cleared Entities")
@Description(value={"Returns list of the cleared entities on Removed Entities event."})
public class ExprClearedEntities
extends SimpleExpression<Entity> {
    public boolean isSingle() {
        return false;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean kl, SkriptParser.ParseResult pr) {
        if (!ScriptLoader.isCurrentEvent(EntityRemoveEvent.class)) {
            Skript.error((String)"You can not use cleared entities expression in any event but on ClearLag remove entities.");
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the entities cleared";
    }

    @Nullable
    protected Entity[] get(Event e) {
        return ((EntityRemoveEvent)e).getEntityList().toArray(new Entity[0]);
    }

    static {
        Skript.registerExpression(ExprClearedEntities.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] entities (cleared|removed|deleted) [by ClearLag[g]]"});
    }
}

