/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.expressions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Cannon from Location")
@Description(value={"Returns the ID of a cannon at a location."})
@Examples(value={"send \"%the id of the cannon at player%\""})
public class ExprCannonIDFromLoc
extends SimpleExpression<String> {
    private Expression<Location> location;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.location = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the ID of cannon at " + this.location.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Cannon cannon;
        if (this.location.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannonsAPI().getCannon((Location)this.location.getSingle(e), null)) == null) {
            return null;
        }
        return new String[]{cannon.getUID().toString()};
    }

    static {
        Skript.registerExpression(ExprCannonIDFromLoc.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [ID of [the]] cannon at %location%"});
    }
}

