/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons.conditions;

import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.cannons.CannonsHook;

@Name(value="Cannons - Is Projectile Pushed")
@Description(value={"Checks if the projectile in a cannon has been pushed."})
@Examples(value={"if projectile in the cannon with id (id of cannon at player) is pushed:"})
public class CondProjectilePushed
extends Condition {
    private Expression<String> id;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.id = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the projectile has been pushed in the cannon with id " + this.id.toString(e, b);
    }

    public boolean check(Event e) {
        Cannon cannon;
        if (this.id.getSingle(e) == null || (cannon = CannonsHook.cannons.getCannon(UUID.fromString((String)this.id.getSingle(e)))) == null) {
            return this.isNegated();
        }
        return cannon.isProjectilePushed() != this.isNegated();
    }

    static {
        Skript.registerCondition(CondProjectilePushed.class, (String[])new String[]{"[the] projectile in [the] cannon [with ID] %string% (is|has been) pushed", "[the] projectile in [the] cannon [with ID] %string% (is(n't| not)|has(n't| not) been) pushed"});
    }
}

