/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bitcoin.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.bitcoin.BitcoinHook;

@Name(value="Bitcoin - Balance of Player")
@Description(value={"Returns the bitcoin balance of a player."})
@Examples(value={"send \"%the bitcoin balance of player%\""})
public class ExprBitcoinBalance
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the bitcoin balance of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        return new Number[]{BitcoinHook.bitcoinAPI.getBalance(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        double amount = ((Number)delta[0]).doubleValue();
        if (mode == Changer.ChangeMode.SET) {
            BitcoinHook.bitcoinAPI.setBalance(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        } else if (mode == Changer.ChangeMode.ADD) {
            BitcoinHook.bitcoinAPI.deposit(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            BitcoinHook.bitcoinAPI.withdraw(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprBitcoinBalance.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] bitcoin bal[ance] of %offlineplayer%", "%offlineplayer%'s bitcoin bal[ance]"});
    }
}

