/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bitcoin.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import us._donut_.skuniversal.bitcoin.BitcoinHook;

@Name(value="Bitcoin - Amount In Bank")
@Description(value={"Returns the amount of bitcoins in the bank."})
@Examples(value={"send \"%the amount of bitcoins in the bank%\""})
public class ExprAmountInBank
extends SimpleExpression<Number> {
    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the amount of bitcoins in the bank";
    }

    @Nullable
    protected Number[] get(Event e) {
        return new Number[]{BitcoinHook.bitcoinAPI.getAmountInBank()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        double amount = ((Number)delta[0]).doubleValue();
        if (mode == Changer.ChangeMode.SET) {
            BitcoinHook.bitcoinAPI.addToBank(amount - BitcoinHook.bitcoinAPI.getAmountInBank());
        } else if (mode == Changer.ChangeMode.ADD) {
            BitcoinHook.bitcoinAPI.addToBank(amount);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            BitcoinHook.bitcoinAPI.removeFromBank(amount);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD ? (Class[])CollectionUtils.array((Object[])new Class[]{Number.class}) : null;
    }

    static {
        Skript.registerExpression(ExprAmountInBank.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (amount|number) of bitcoins in [the] bank"});
    }
}

