/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bedwars.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.MineHome.Bedwars.Game.GameManager;
import org.bukkit.event.Event;

@Name(value="Bedwars - Game Exists")
@Description(value={"Checks if a Bedwars game with given name exists."})
@Examples(value={"if bedwars game text-argument exists:"})
public class CondGameExists
extends Condition {
    private Expression<String> game;

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.game = e[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "Bedwars game " + this.game.toString(e, b) + " exists";
    }

    public boolean check(Event e) {
        if (this.game.getSingle(e) == null) {
            return this.isNegated();
        }
        return GameManager.existGame((String)((String)this.game.getSingle(e))) != this.isNegated();
    }

    static {
        Skript.registerCondition(CondGameExists.class, (String[])new String[]{"[a] [Bedwars] game [(named|with name)] %string% exists", "[a] [Bedwars] game [(named|with name)] %string% does(n't| not) exist"});
    }
}

