/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.autorank.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.armar.plugins.autorank.pathbuilder.holders.RequirementsHolder;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us._donut_.skuniversal.autorank.AutorankHook;

@Name(value="Autorank - Failed Requirements")
@Description(value={"Returns list of the failed requirements of a player."})
@Examples(value={"send \"Your failed requirements: %failed requirements of player%\""})
public class ExprFailedReqs
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "failed requirements of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (String[])AutorankHook.autorankAPI.getFailedRequirements((Player)this.player.getSingle(e)).stream().map(RequirementsHolder::getDescription).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprFailedReqs.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] failed [Autorank] (requirements|reqs) of %player%", "[all of] %player%'s failed [Autorank] (requirements|reqs)"});
    }
}

