/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.advancedban.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.leoko.advancedban.utils.Punishment;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.skuniversal.advancedban.AdvancedBanHook;

@Name(value="AdvancedBan - Punishments")
@Description(value={"Returns the active punishments of a player."})
@Examples(value={"send \"Your punishments: %active punishments of player%\""})
public class ExprPunishments
extends SimpleExpression<String> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the punishments of player " + this.player.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) == null) {
            return null;
        }
        return (String[])AdvancedBanHook.punishmentManager.getPunishments(AdvancedBanHook.uuidManager.getUUID(((OfflinePlayer)this.player.getSingle(e)).getName()), null, true).stream().map(Punishment::getName).toArray(String[]::new);
    }

    static {
        Skript.registerExpression(ExprPunishments.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] [(current|active)] [AdvancedBan] punishments of %offlineplayer%", "[all of] %offlineplayer%'s [(current|active)] [AdvancedBan] punishments"});
    }
}

