/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.slimefun;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.events.bukkit.SkriptStartEvent;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.LockedCategory;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import us._donut_.skuniversal.slimefun.SlimefunRegister;

@Name(value="Slimefun - Create Locked Category")
@Description(value={"Creates Slimefun locked category (it will not show up in the guide unless you create at least 1 item for it)"})
@Examples(value={"create locked slimefun category named \"Locked Cool Stuff\" with menu item dirt named \"Locked Cool Stuff\" with priority 0 with required categories \"RESOURCES\""})
public class EffCreateLockedCategory
extends Effect {
    private Expression<String> name;
    private Expression<ItemStack> item;
    private Expression<Integer> level;
    private Expression<String> categories;

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult p) {
        if (!ScriptLoader.isCurrentEvent(SkriptStartEvent.class)) {
            Skript.error((String)"You can not use Slimefun create locked category effect in any event but on skript load.");
            return false;
        }
        this.name = e[0];
        this.item = e[1];
        this.level = e[2];
        this.categories = e[3];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "create Slimefun category " + this.name.toString(e, b) + " with item " + this.item.toString(e, b) + " with level " + this.level.toString(e, b) + " with required categories " + this.categories.toString(e, b);
    }

    protected void execute(Event e) {
        ArrayList<Category> requiredCategories = new ArrayList<Category>();
        for (String categoryString : (String[])this.categories.getArray(e)) {
            try {
                requiredCategories.add((Category)Categories.class.getField(categoryString).get(Category.class));
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                if (!SlimefunRegister.customCategories.containsKey(categoryString.toLowerCase())) continue;
                requiredCategories.add(SlimefunRegister.customCategories.get(categoryString.toLowerCase()));
            }
        }
        SlimefunRegister.customCategories.put(((String)this.name.getSingle(e)).toLowerCase(), (Category)new LockedCategory((ItemStack)this.item.getSingle(e), ((Integer)this.level.getSingle(e)).intValue(), requiredCategories.toArray(new Category[0])));
    }
}

