/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopkeepers;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.nisovin.shopkeepers.api.shopkeeper.Shopkeeper;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Shopkeepers - Shopkeeper Name")
@Description(value={"Returns the name of a shopkeeper."})
@Examples(value={"send \"%the name of the shopkeeper with id 1\""})
public class ExprKeeperName
extends SimpleExpression<String> {
    private Expression<Integer> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "name of shopkeeper with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Shopkeeper shopkeeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperById(((Integer)this.id.getSingle(e)).intValue());
        return new String[]{shopkeeper == null ? null : shopkeeper.getName()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Shopkeeper shopkeeper;
        if (mode == Changer.ChangeMode.SET && (shopkeeper = ShopkeepersAPI.getShopkeeperRegistry().getShopkeeperById(((Integer)this.id.getSingle(e)).intValue())) != null) {
            shopkeeper.setName((String)delta[0]);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

