/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.intellectualcrafters.plot.object.Plot;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import us._donut_.skuniversal.plotsquared.PlotSquaredRegister;

@Name(value="PlotSquared - Plot Border Blocks")
@Description(value={"Returns the border blocks of a plot."})
@Examples(value={"send \"%the border blocks at height 65 of the plot with id (id of plot at player)%\""})
public class ExprBorderBlocks
extends SimpleExpression<Block> {
    private Expression<String> id;
    private Expression<Number> borderHeight;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.borderHeight = e[0];
        this.id = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "border blocks of plot of with id " + this.id.toString(e, b);
    }

    private Boolean isNorthEastCorner(com.intellectualcrafters.plot.object.Location cornerInQuestion, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        return cornerInQuestion.getZ() <= corner2.getZ() && cornerInQuestion.getZ() <= corner3.getZ() && cornerInQuestion.getZ() <= corner4.getZ() && cornerInQuestion.getX() >= corner2.getX() && cornerInQuestion.getX() >= corner3.getX() && cornerInQuestion.getX() >= corner4.getX();
    }

    private Boolean isNorthWestCorner(com.intellectualcrafters.plot.object.Location cornerInQuestion, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        return cornerInQuestion.getZ() <= corner2.getZ() && cornerInQuestion.getZ() <= corner3.getZ() && cornerInQuestion.getZ() <= corner4.getZ() && cornerInQuestion.getX() <= corner2.getX() && cornerInQuestion.getX() <= corner3.getX() && cornerInQuestion.getX() <= corner4.getX();
    }

    private Boolean isSouthEastCorner(com.intellectualcrafters.plot.object.Location cornerInQuestion, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        return cornerInQuestion.getZ() >= corner2.getZ() && cornerInQuestion.getZ() >= corner3.getZ() && cornerInQuestion.getZ() >= corner4.getZ() && cornerInQuestion.getX() >= corner2.getX() && cornerInQuestion.getX() >= corner3.getX() && cornerInQuestion.getX() >= corner4.getX();
    }

    private Boolean isSouthWestCorner(com.intellectualcrafters.plot.object.Location cornerInQuestion, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        return cornerInQuestion.getZ() >= corner2.getZ() && cornerInQuestion.getZ() >= corner3.getZ() && cornerInQuestion.getZ() >= corner4.getZ() && cornerInQuestion.getX() <= corner2.getX() && cornerInQuestion.getX() <= corner3.getX() && cornerInQuestion.getX() <= corner4.getX();
    }

    private com.intellectualcrafters.plot.object.Location getNorthEastCorner(com.intellectualcrafters.plot.object.Location corner1, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        if (this.isNorthEastCorner(corner1, corner2, corner3, corner4).booleanValue()) {
            return corner1;
        }
        if (this.isNorthEastCorner(corner2, corner1, corner3, corner4).booleanValue()) {
            return corner2;
        }
        if (this.isNorthEastCorner(corner3, corner4, corner2, corner1).booleanValue()) {
            return corner3;
        }
        return corner4;
    }

    private com.intellectualcrafters.plot.object.Location getNorthWestCorner(com.intellectualcrafters.plot.object.Location corner1, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        if (this.isNorthWestCorner(corner1, corner2, corner3, corner4).booleanValue()) {
            return corner1;
        }
        if (this.isNorthWestCorner(corner2, corner1, corner3, corner4).booleanValue()) {
            return corner2;
        }
        if (this.isNorthWestCorner(corner3, corner4, corner2, corner1).booleanValue()) {
            return corner3;
        }
        return corner4;
    }

    private com.intellectualcrafters.plot.object.Location getSouthEastCorner(com.intellectualcrafters.plot.object.Location corner1, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        if (this.isSouthEastCorner(corner1, corner2, corner3, corner4).booleanValue()) {
            return corner1;
        }
        if (this.isSouthEastCorner(corner2, corner1, corner3, corner4).booleanValue()) {
            return corner2;
        }
        if (this.isSouthEastCorner(corner3, corner4, corner2, corner1).booleanValue()) {
            return corner3;
        }
        return corner4;
    }

    private com.intellectualcrafters.plot.object.Location getSouthWestCorner(com.intellectualcrafters.plot.object.Location corner1, com.intellectualcrafters.plot.object.Location corner2, com.intellectualcrafters.plot.object.Location corner3, com.intellectualcrafters.plot.object.Location corner4) {
        if (this.isSouthWestCorner(corner1, corner2, corner3, corner4).booleanValue()) {
            return corner1;
        }
        if (this.isSouthWestCorner(corner2, corner1, corner3, corner4).booleanValue()) {
            return corner2;
        }
        if (this.isSouthWestCorner(corner3, corner4, corner2, corner1).booleanValue()) {
            return corner3;
        }
        return corner4;
    }

    @Nullable
    protected Block[] get(Event e) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Plot plot = PlotSquaredRegister.getPlot((String)this.id.getSingle(e));
        if (plot == null) {
            return null;
        }
        if (plot.getAllCorners().size() == 4) {
            double z;
            double x;
            com.intellectualcrafters.plot.object.Location northEastCorner = this.getNorthEastCorner((com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(0), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(1), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(2), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(3)).add(1, ((Number)this.borderHeight.getSingle(e)).intValue(), -1);
            com.intellectualcrafters.plot.object.Location northWestCorner = this.getNorthWestCorner((com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(0), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(1), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(2), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(3)).add(-1, ((Number)this.borderHeight.getSingle(e)).intValue(), -1);
            com.intellectualcrafters.plot.object.Location southEastCorner = this.getSouthEastCorner((com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(0), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(1), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(2), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(3)).add(1, ((Number)this.borderHeight.getSingle(e)).intValue(), 1);
            com.intellectualcrafters.plot.object.Location southWestCorner = this.getSouthWestCorner((com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(0), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(1), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(2), (com.intellectualcrafters.plot.object.Location)plot.getAllCorners().get(3)).add(-1, ((Number)this.borderHeight.getSingle(e)).intValue(), 1);
            for (x = (double)northWestCorner.getX(); x < (double)(northEastCorner.getX() + 1); x += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northWestCorner.getWorld()), x, (double)((Number)this.borderHeight.getSingle(e)).intValue(), (double)northWestCorner.getZ()).getBlock());
            }
            for (z = (double)northEastCorner.getZ(); z < (double)(southEastCorner.getZ() + 1); z += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northEastCorner.getWorld()), (double)northEastCorner.getX(), (double)((Number)this.borderHeight.getSingle(e)).intValue(), z).getBlock());
            }
            for (z = (double)northWestCorner.getZ(); z < (double)(southWestCorner.getZ() + 1); z += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)northWestCorner.getWorld()), (double)northWestCorner.getX(), (double)((Number)this.borderHeight.getSingle(e)).intValue(), z).getBlock());
            }
            for (x = (double)southWestCorner.getX(); x < (double)(southEastCorner.getX() + 1); x += 1.0) {
                blocks.add(new Location(Bukkit.getWorld((String)southWestCorner.getWorld()), x, (double)((Number)this.borderHeight.getSingle(e)).intValue(), (double)southWestCorner.getZ()).getBlock());
            }
            return blocks.toArray(new Block[0]);
        }
        return null;
    }
}

