/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons;

import at.pavlov.cannons.Cannons;
import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Cannons - Cannon Pitch")
@Description(value={"Returns the pitch of a cannon."})
@Examples(value={"send \"%the pitch of the cannon with id (id of cannon at player)%\""})
public class ExprCannonPitch
extends SimpleExpression<Number> {
    private Expression<String> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the pitch of the cannon with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        Number[] numberArray;
        Cannon cannon = Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e)));
        if (cannon == null) {
            numberArray = null;
        } else {
            Number[] numberArray2 = new Number[1];
            numberArray = numberArray2;
            numberArray2[0] = cannon.getAimingPitch();
        }
        return numberArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number newPitch = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).setAimingPitch(newPitch.doubleValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).setAimingPitch(Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).getTemperature() + newPitch.doubleValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).setAimingPitch(Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).getTemperature() - newPitch.doubleValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

