/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.cannons;

import at.pavlov.cannons.Cannons;
import at.pavlov.cannons.cannon.Cannon;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Cannons - Cannon Owner")
@Description(value={"Returns the owner of a cannon."})
@Examples(value={"send \"%the owner of the cannon with id (id of cannon at player)%\""})
public class ExprCannonOwner
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "the owner of cannon with ID " + this.id.toString(e, b);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        OfflinePlayer[] offlinePlayerArray;
        Cannon cannon = Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e)));
        if (cannon == null) {
            offlinePlayerArray = null;
        } else {
            OfflinePlayer[] offlinePlayerArray2 = new OfflinePlayer[1];
            offlinePlayerArray = offlinePlayerArray2;
            offlinePlayerArray2[0] = Bukkit.getOfflinePlayer((UUID)cannon.getOwner());
        }
        return offlinePlayerArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer newOwner = (OfflinePlayer)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Cannons.getPlugin().getCannon(UUID.fromString((String)this.id.getSingle(e))).setOwner(newOwner.getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }
}

