/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.Node;
import org.bukkit.event.Event;

@Name(value="LuckPerms - Permissions of Group")
@Description(value={"Returns the permissions of a group."})
@Examples(value={"set {default::perms::*} to the permissions of the luckperms group \"default\""})
public class ExprGroupPermissions
extends SimpleExpression<String> {
    private Expression<String> group;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.group = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "luckperms permissions of group " + this.group.toString(e, b);
    }

    @Nullable
    protected String[] get(Event e) {
        Group lpGroup = LuckPerms.getApi().getGroup((String)this.group.getSingle(e));
        return lpGroup == null ? null : (String[])lpGroup.getPermissions().stream().map(Node::getPermission).toArray(String[]::new);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Group groupBeingChanged = LuckPerms.getApi().getGroup((String)this.group.getSingle(e));
        if (groupBeingChanged == null) {
            return;
        }
        if (mode == Changer.ChangeMode.RESET) {
            groupBeingChanged.clearNodes();
        } else if (mode == Changer.ChangeMode.DELETE) {
            groupBeingChanged.clearNodes();
        } else if (mode == Changer.ChangeMode.ADD) {
            groupBeingChanged.setPermission(LuckPerms.getApi().getNodeFactory().newBuilder((String)delta[0]).build());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            groupBeingChanged.unsetPermission(LuckPerms.getApi().getNodeFactory().newBuilder((String)delta[0]).build());
        }
        LuckPerms.getApi().getStorage().saveGroup(groupBeingChanged);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

