/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="GriefPrevention - Claim IDs")
@Description(value={"Returns the claim IDs of claims."})
@Examples(value={"send \"%the ids of the basic claims of player%\""})
public class ExprClaimIDs
extends SimpleExpression<Number> {
    private Expression<Location> location;
    private Expression<OfflinePlayer> player;
    private String claimType;

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        switch (pr.mark) {
            case 0: {
                this.claimType = "normal";
                break;
            }
            case 1: {
                this.claimType = "admin";
                break;
            }
            case 2: {
                this.claimType = "sub-claim";
                break;
            }
            case 3: {
                this.claimType = "all";
                break;
            }
            case 4: {
                this.claimType = "normal";
                this.location = e[0];
                break;
            }
            case 5: {
                this.claimType = "admin";
                this.location = e[0];
                break;
            }
            case 6: {
                this.claimType = "sub-claim";
                this.location = e[0];
                break;
            }
            case 7: {
                this.claimType = "all";
                this.location = e[0];
                break;
            }
            case 8: {
                this.claimType = "normal";
                this.player = e[1];
                break;
            }
            case 9: {
                this.claimType = "admin";
                this.player = e[1];
                break;
            }
            case 10: {
                this.claimType = "sub-claim";
                this.player = e[1];
                break;
            }
            case 11: {
                this.claimType = "all";
                this.player = e[1];
            }
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean arg) {
        return "claim IDs";
    }

    @Nullable
    protected Number[] get(Event e) {
        List<Object> claims = new ArrayList(GriefPrevention.instance.dataStore.getClaims());
        for (Claim claim2 : GriefPrevention.instance.dataStore.getClaims()) {
            claims.addAll(claim2.children);
        }
        if (this.claimType.equalsIgnoreCase("normal")) {
            claims = claims.stream().filter(claim -> !claim.isAdminClaim() && claim.parent == null).collect(Collectors.toList());
        } else if (this.claimType.equalsIgnoreCase("admin")) {
            claims = claims.stream().filter(Claim::isAdminClaim).collect(Collectors.toList());
        } else if (this.claimType.equalsIgnoreCase("sub-claim")) {
            claims = claims.stream().filter(claim -> claim.parent != null).collect(Collectors.toList());
        }
        if (this.location != null) {
            claims = claims.stream().filter(claim -> claim.contains((Location)this.location.getSingle(e), true, false)).collect(Collectors.toList());
        } else if (this.player != null) {
            claims = claims.stream().filter(claim -> claim.ownerID.equals(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())).collect(Collectors.toList());
        }
        return (Number[])claims.stream().map(Claim::getID).toArray(Number[]::new);
    }
}

