/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.skywars_cookloco;

import ak.CookLoco.SkyWars.api.SkyWarsAPI;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="SkyWars (CookLoco) - Player Kills")
@Description(value={"Returns the amount of skywars kills of a player."})
@Examples(value={"send \"%the skywars kills of player%\""})
public class ExprSkyWarsKills
extends SimpleExpression<Number> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "SkyWars kills of player " + this.player.toString(e, b);
    }

    @Nullable
    protected Number[] get(Event e) {
        return new Number[]{SkyWarsAPI.getKills((Player)((Player)this.player.getSingle(e)))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number killsChange = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            SkyWarsAPI.getSkyPlayer((Player)((Player)this.player.getSingle(e))).setKills(killsChange.intValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            SkyWarsAPI.getSkyPlayer((Player)((Player)this.player.getSingle(e))).addKills(killsChange.intValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            SkyWarsAPI.getSkyPlayer((Player)((Player)this.player.getSingle(e))).setKills(SkyWarsAPI.getKills((Player)((Player)this.player.getSingle(e))) - killsChange.intValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

