/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.shopchest;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import de.epiceric.shopchest.ShopChest;
import de.epiceric.shopchest.shop.Shop;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="ShopChest - Shop Buy Price")
@Description(value={"Returns the buy price of a shop."})
@Examples(value={"send \"%the buy price of shop with id (shop at player)%\""})
public class ExprBuyPrice
extends SimpleExpression<Number> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "the buy price of the shop with id " + this.id.getSingle(e);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.id.getSingle(e) != null) {
            for (Shop shop : ShopChest.getInstance().getShopUtils().getShops()) {
                if (!shop.hasId() || shop.getID() != ((Number)this.id.getSingle(e)).intValue()) continue;
                return new Number[]{shop.getBuyPrice()};
            }
            Skript.error((String)"Invalid shop ID, please refer to the syntax");
            return null;
        }
        Skript.error((String)"Must provide a number, please refer to the syntax");
        return null;
    }
}

