/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.alessiodp.parties.Parties;
import com.alessiodp.parties.utils.api.PartiesAPI;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Parties - Party Leader")
@Description(value={"Returns the leader of a party."})
@Examples(value={"send \"%the leader of the party named \"cool\"%\""})
public class ExprLeader
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "leader of party named " + (String)this.name.getSingle(e);
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        if (this.name.getSingle(e) != null) {
            PartiesAPI parties = new PartiesAPI();
            return new OfflinePlayer[]{Bukkit.getOfflinePlayer((UUID)parties.getPartyLeader((String)this.name.getSingle(e)))};
        }
        Skript.error((String)"Must provide a string, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer newLeader = (OfflinePlayer)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Parties.getInstance().getPartyHandler().loadParty((String)this.name.getSingle(e)).setLeader(newLeader.getUniqueId());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }
}

