/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="LuckPerms - Group of Player")
@Description(value={"Returns the group of a player."})
@Examples(value={"send \"%the luckperms group of player%\""})
public class ExprGroupOfPlayer
extends SimpleExpression<String> {
    private Expression<Player> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "luckperms group of player";
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            return new String[]{LuckPerms.getApi().getUser(((Player)this.player.getSingle(e)).getUniqueId()).getPrimaryGroup()};
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            User user = LuckPerms.getApi().getUser(((Player)this.player.getSingle(e)).getUniqueId());
            user.setPrimaryGroup((String)delta[0]);
            LuckPerms.getApi().getStorage().saveUser(user);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

