/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.bitcoin;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import us._donut_.bitcoin.Bitcoin;

@Name(value="Bitcoin - Balance of Player")
@Description(value={"Returns the bitcoin balance of a player."})
@Examples(value={"send \"%the bitcoin balance of player%\""})
public class ExprBitcoinBalance
extends SimpleExpression<Number> {
    private Expression<OfflinePlayer> player;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.player = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "the bitcoin balance of player " + this.player.getSingle(e);
    }

    @Nullable
    protected Number[] get(Event e) {
        if (this.player.getSingle(e) != null) {
            return new Number[]{Bitcoin.getAPI().getBalance(((OfflinePlayer)this.player.getSingle(e)).getUniqueId())};
        }
        Skript.error((String)"Must provide a player, please refer to the syntax");
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Number amount = (Number)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Bitcoin.getAPI().setBalance(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.doubleValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            Bitcoin.getAPI().deposit(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.doubleValue());
        } else if (mode == Changer.ChangeMode.REMOVE) {
            Bitcoin.getAPI().withdraw(((OfflinePlayer)this.player.getSingle(e)).getUniqueId(), amount.doubleValue());
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

