/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.parties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.alessiodp.parties.Parties;
import com.alessiodp.parties.utils.api.PartiesAPI;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Parties - Party Home")
@Description(value={"Returns the home location of a party."})
@Examples(value={"send \"%the home of the party named \"cool\"%\""})
public class ExprHome
extends SimpleExpression<Location> {
    private Expression<String> name;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.name = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean b) {
        return "home location of party named " + this.name.toString(e, b);
    }

    @Nullable
    protected Location[] get(Event e) {
        return new Location[]{new PartiesAPI().getPartyHome((String)this.name.getSingle(e))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Location newLoc = (Location)delta[0];
        if (mode == Changer.ChangeMode.SET) {
            Parties.getInstance().getPartyHandler().loadParty((String)this.name.getSingle(e)).setHome(newLoc);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
        }
        return null;
    }
}

