/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.plotsquared;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.intellectualcrafters.plot.api.PlotAPI;
import com.intellectualcrafters.plot.flag.Flags;
import com.intellectualcrafters.plot.object.Plot;
import com.intellectualcrafters.plot.object.PlotId;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="PlotSquared - Set Flag")
@Description(value={"Sets flag in a plot."})
@Examples(value={"set flag \"player-interact\" to true in the plot with id (id of plot at player)"})
public class EffSetFlag
extends Effect {
    private Expression<String> id;
    private Expression<String> flag;
    private Expression<Boolean> value;

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult p) {
        this.id = e[2];
        this.flag = e[0];
        this.value = e[1];
        return true;
    }

    public String toString(@Nullable Event e, boolean paramBoolean) {
        return "set flag " + (String)this.flag.getSingle(e) + " to " + this.value.getSingle(e) + " in plot with id " + (String)this.id.getSingle(e);
    }

    protected void execute(Event e) {
        if (this.id.getSingle(e) != null && this.flag.getSingle(e) != null) {
            if (this.value.getSingle(e) != null) {
                PlotAPI plot = new PlotAPI();
                PlotId plotId = PlotId.fromString((String)((String)this.id.getSingle(e)));
                if (plotId == null) {
                    Skript.error((String)"Invalid plot ID, please refer to the syntax");
                } else {
                    for (Plot aPlot : plot.getAllPlots()) {
                        if (!aPlot.getId().equals((Object)plotId)) continue;
                        aPlot.setFlag(Flags.getFlag((String)((String)this.flag.getSingle(e))), this.value.getSingle(e));
                    }
                }
            } else {
                Skript.error((String)"Must provide a boolean, please refer to the syntax");
            }
        } else {
            Skript.error((String)"Must provide a string, please refer to the syntax");
        }
    }
}

