/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.luckperms;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="LuckPerms - Add Prefix")
@Description(value={"Adds prefix to player."})
@Examples(value={"add \"[Owner]\" with priority 100 to the prefixes of player"})
public class EffAddPrefix
extends Effect {
    private Expression<String> prefix;
    private Expression<Number> priority;
    private Expression<Player> player;

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult p) {
        this.prefix = e[0];
        this.priority = e[1];
        this.player = e[2];
        return true;
    }

    public String toString(@Nullable Event e, boolean paramBoolean) {
        return "add prefix with priority to player";
    }

    protected void execute(Event e) {
        if (this.prefix.getSingle(e) != null) {
            if (this.priority.getSingle(e) != null) {
                if (this.player != null) {
                    User user = LuckPerms.getApi().getUser(((Player)this.player.getSingle(e)).getUniqueId());
                    user.setPermission(LuckPerms.getApi().getNodeFactory().makePrefixNode(((Number)this.priority.getSingle(e)).intValue(), (String)this.prefix.getSingle(e)).build());
                    LuckPerms.getApi().getStorage().saveUser(user);
                } else {
                    Skript.error((String)"Must provide a player, please refer to the syntax");
                }
            } else {
                Skript.error((String)"Must provide a number, please refer to the syntax");
            }
        } else {
            Skript.error((String)"Must provide a string, please refer to the syntax");
        }
    }
}

