/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.griefprevention;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.event.Event;
import us._donut_.skuniversal.griefprevention.GriefPreventionRegister;

@Name(value="GriefPrevention - Lesser Corner")
@Description(value={"Returns the lesser corner of a claim."})
@Examples(value={"send \"%the lesser corner of the claim with id (id of the basic claim at player)%\""})
public class ExprLesserCorner
extends SimpleExpression<Location> {
    private Expression<Number> id;

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult pr) {
        this.id = e[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "lesser boundary corner of claim with id " + this.id.getSingle(e);
    }

    @Nullable
    protected Location[] get(Event e) {
        if (this.id.getSingle(e) != null) {
            Claim claim = GriefPreventionRegister.getClaim(((Number)this.id.getSingle(e)).longValue());
            if (claim != null) {
                return new Location[]{GriefPrevention.instance.dataStore.getClaim(((Number)this.id.getSingle(e)).longValue()).getLesserBoundaryCorner()};
            }
            Skript.error((String)"Invalid claim ID, please refer to the syntax");
            return null;
        }
        Skript.error((String)"Must provide a number, please refer to the syntax");
        return null;
    }
}

