/*
 * Decompiled with CFR 0.152.
 */
package us._donut_.skuniversal.slimefun;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.events.bukkit.ScriptEvent;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Slimefun - Create Item")
@Description(value={"Creates Slimefun item - Categories: https://pastebin.com/HF63gBBj | Recipe Types: https://pastebin.com/G5thupbG"})
@Examples(value={"set {_recipe::*} to dirt, dirt, dirt, dirt, dirt, dirt, dirt, dirt, and dirt\ncreate slimefun item dirt named \"Cool Dirt\" with lore \"Not your ordinary dirt!\" with id \"COOL_DIRT\" in category \"RESOURCES\" with recipe {_recipe::*} with recipe type \"ENHANCED_CRAFTING_TABLE\""})
public class EffCreateItem
extends Effect {
    private Expression<ItemStack> item;
    private Expression<String> id;
    private Expression<String> category;
    private Expression<ItemStack> recipe;
    private Expression<String> recipeType;

    public boolean init(Expression<?>[] e, int i, Kleenean kl, SkriptParser.ParseResult p) {
        if (!ScriptLoader.isCurrentEvent(ScriptEvent.class)) {
            Skript.error((String)"You can not use Slimefun create item expression in any event but on script load.");
            return false;
        }
        this.item = e[0];
        this.id = e[1];
        this.category = e[2];
        this.recipe = e[3];
        this.recipeType = e[4];
        return true;
    }

    public String toString(@Nullable Event e, boolean paramBoolean) {
        return "create Slimefun item";
    }

    protected void execute(Event e) {
        if (this.item != null && this.id != null && this.category != null && this.recipe != null && this.recipeType != null) {
            RecipeType actualRecipeType;
            Category actualCategory;
            try {
                actualCategory = (Category)Categories.class.getField((String)this.category.getSingle(e)).get(Category.class);
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                actualCategory = Categories.MISC;
            }
            try {
                actualRecipeType = (RecipeType)RecipeType.class.getField((String)this.recipeType.getSingle(e)).get(RecipeType.class);
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                actualRecipeType = RecipeType.ENHANCED_CRAFTING_TABLE;
            }
            SlimefunItem slimefunItem = new SlimefunItem(actualCategory, (ItemStack)this.item.getSingle(e), (String)this.id.getSingle(e), actualRecipeType, (ItemStack[])this.recipe.getArray(e));
            slimefunItem.register();
        } else {
            Skript.error((String)"Must provide a non-null value, please refer to the syntax");
        }
    }
}

